package jcircus.util;

/**
 * Defines the constants used in the program.
 *
 * @author Angela Freitas
 *
 */
public class Constants {
    
    /* Velocity parameters */
    public static final String PROJECT_NAME = "proj";
    
    public static final String $_CLASS_NAME = "className";
    public static final String $_CLASS_BODY = "classBody";
    
    public static final String $_STATEDECL      = "stateDecl";
    public static final String $_PROCPARAGRAPHS = "pPars";
    public static final String $_MAINACTION     = "mainAction";
    
    /* Names of packages */    
    public static final String PKG_PROCESSES    = "processes";
    public static final String PKG_AXDEFS       = "axiomaticDefinitions";
    public static final String PKG_TYPING       = "typing";
    public static final String PKG_UTIL         = "util";
    public static final String PKG_GUI          = "gui";
    
    /* Name of the source directory */
    public static final String DIR_SOURCE       = "src";
    
    /* Location of resources */
//    private static final String DIR_TEMPLATES   = "templates\\";
//    public static final String DIR_EXAMPLES = "D:\\Angela\\Research\\Java\\JCircus\\src\\examples";
//    public static final String DIR_PROJECTS = "D:\\Angela\\Research\\Java\\Translator";

// Use this when generating the binary distribution //////////////////////////////////
    private static final String DIR_TEMPLATES = "";
    public static final String DIR_EXAMPLES = "./examples";
    public static final String DIR_PROJECTS = "./output";
//////////////////////////////////////////////////////////////////////////////////////
    
    /* Velocity templates */
    public static final String TMP_BAT          = DIR_TEMPLATES + "BatFile.vm";
    public static final String TMP_ACTPARALLEL  = DIR_TEMPLATES + "ActionParallelism.vm";
    public static final String TMP_BASICPROC    = DIR_TEMPLATES + "BasicProcess.vm";
    public static final String TMP_CIRCINT      = DIR_TEMPLATES + "CircusInteger.vm";
    public static final String TMP_MAIN         = DIR_TEMPLATES + "Main.vm";
    public static final String TMP_PROCDECL     = DIR_TEMPLATES + "ProcDeclaration.vm";
    public static final String TMP_RANDOMGEN    = DIR_TEMPLATES + "RandomGenerator.vm";
    public static final String TMP_RECACTION    = DIR_TEMPLATES + "MuAction.vm";
    public static final String TMP_SUBTYPE      = DIR_TEMPLATES + "SubClassOfType.vm";
    public static final String TMP_TYPE         = DIR_TEMPLATES + "Type.vm";
    public static final String TMP_GUI          = DIR_TEMPLATES + "Gui.vm";
    public static final String TMP_INITGUICHSYNC    = DIR_TEMPLATES + "InitCompGuiChannelSync.vm";    
    public static final String TMP_INITGUICHCOMM    = DIR_TEMPLATES + "InitCompGuiChannelComm.vm";    
    public static final String TMP_CTRLCALL     = DIR_TEMPLATES + "msControlCall.vm";
    public static final String TMP_CALLMAIN     = DIR_TEMPLATES + "callMain.vm";
    public static final String TMP_AUXMETHODS   = DIR_TEMPLATES + "AuxiliarMethods.vm";
    public static final String TMP_GENCHANNEL   = DIR_TEMPLATES + "GeneralChannel.vm";
    public static final String TMP_MSCLIENT     = DIR_TEMPLATES + "MultiSyncClient.vm";
    public static final String TMP_MSCONTROL    = DIR_TEMPLATES + "MultiSyncControl.vm";
    public static final String TMP_MSINFO       = DIR_TEMPLATES + "MultiSyncInfo.vm";
    public static final String TMP_PAR_CALL     = DIR_TEMPLATES + "parCall.vm";
    public static final String TMP_AXDEFS       = DIR_TEMPLATES + "AxiomaticDefinitions.vm";
    public static final String TMP_CTRL_MNGR_CALL     = DIR_TEMPLATES + "ControllersManagerCall.vm";
    public static final String TMP_PROC_MNGR_CALL     = DIR_TEMPLATES + "ProcessManagerCall.vm";

    /* Name of Source Files */
    public static final String CLS_AXDEFS   = "AxiomaticDefinitions";
    public static final String CLS_TYPE     = "Type";
    public static final String CLS_CHINFO   = "ChannelInfo";
    public static final String CLS_CIRCINT  = "CircusInteger";
    public static final String CLS_GENCHAN  = "GeneralChannel";

    /* Java extension */
    public static final String JAVA_EXT     = ".java";
    
    /* Auxiliar */
    public static final int OP_INTCHOICE = 0;
    public static final int OP_EXTCHOICE = 1;
    
    
}
